// -*- Mode: C++; -*-
//				Package : omnithread
// omnithread/atomic.h		Created : 2011/04/14 dgrisby
//
//    Copyright (C) 2011-2025 Apasphere Ltd
//
//    This file is part of the omnithread library
//
//    The omnithread library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with this library. If not, see http://www.gnu.org/licenses/
//

//
// Atomic operations for platforms that support them.

#ifndef __omnithread_atomic_h_
#define __omnithread_atomic_h_

#ifndef OMNI_DISABLE_ATOMIC_OPS

#include <atomic>


///////////////////////////////////////////////////////////////////////////
//
// Reference count
//
///////////////////////////////////////////////////////////////////////////

class _OMNITHREAD_NTDLL_ omni_refcount {
public:
  inline omni_refcount(int start) : count(start) {}
  inline ~omni_refcount() {}
  
  // Atomically increment reference count
  inline void inc() {
    count.fetch_add(1, std::memory_order_relaxed);
  }

  inline int operator++() {
    return count.fetch_add(1, std::memory_order_relaxed) + 1;
  }

  // Atomically decrement reference count and return new value
  inline int dec() {
    return count.fetch_sub(1, std::memory_order_acq_rel) - 1;
  }

  inline int operator--() {
    return count.fetch_sub(1, std::memory_order_acq_rel) - 1;
  }

  // Return snapshot of current value. Real count may have changed by
  // the time the value is looked at!
  inline int value() {
    return count.load(std::memory_order_relaxed);
  }

private:
  std::atomic<int> count;
};


#endif // OMNI_DISABLE_ATOMIC_OPS

#endif // __omnithread_atomic_h_
